package org.masstheory;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DlgMain extends JFrame implements ActionListener {
  
  private static final long serialVersionUID = 6147602086583431819L;
  
  Pioneer pioneer = null;
  
  JPanel panel;
  JMenuBar menuBar;
  
  JLabel labelSpacecraft = new JLabel("spacecraft:");
  JComboBox comboSpacecraft = new JComboBox(new String[] { "Pioneer 10", "Pioneer 11" });
  
  JLabel labelStartFrom = new JLabel("start from:");
  JComboBox comboStartFrom = new JComboBox(new String[] { });
  
  JLabel labelEndAt = new JLabel("end at:");
  JComboBox comboEndAt = new JComboBox(new String[] { });

  JTextArea textArea = new JTextArea();
  JScrollPane scrollableText = new JScrollPane(textArea);
  
  JLabel labelDistance = new JLabel("Distance");
  JLabel labelAcc = new JLabel("Acceleration");
  JLabel labelAccUnit1 = new JLabel("x 1e-10 m/s^2");
  JLabel labelAccUnit2 = new JLabel("x 1e-10 m/s^2");
  
  JLabel labelAU1 = new JLabel("AU");
  JLabel labelAU2 = new JLabel("AU");
  
  JLabel labelDrift = new JLabel("drift:");
  JLabel labelDriftUnit = new JLabel("Km");
  JLabel labelDriftSpeed = new JLabel("drift speed:");
  JLabel labelSpeedUnit = new JLabel("m/s");
  JLabel labelTime = new JLabel("time:");
  JLabel labelYear = new JLabel("years");
  JLabel labelEquivAcc = new JLabel("Equiv. const. acceleration:");
  
  JTextField textDrift = new JTextField();
  JTextField textDriftSpeed = new JTextField();
  JTextField textTime = new JTextField();
  JTextField textEquivAcc = new JTextField();
  
  String msg = "This software calculates dynamic component of gravity \n" +
      "using the theory of asynchronous interaction, which is \n" +
      "available at <a href='http://www.masstheory.org'>www.masstheory.org</a>";
  
  
  String[] roundDistances = new String[] { };
  
  public DlgMain() {
    setDefaultCloseOperation(EXIT_ON_CLOSE);
    pioneer = new Pioneer(this);
  }
  
  void init() {
    
    setSize(550, 330);
    setTitle("Explanation of The Pioneer Anomaly");
    
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screenSize = toolkit.getScreenSize();
    
    int x = (screenSize.width - getWidth()) / 2;
    int y = (screenSize.height - getHeight()) / 2;

    setLocation(x, y);
    setResizable(false);
    
    
    roundDistances = new String[98];
    for (int i = 0; i < roundDistances.length; i++) {
      roundDistances[i] = "" + (i + 3);
    }
    
    setResizable(false);
    
    JMenu menu = new JMenu("Help");
    JMenuItem menuItem = new JMenuItem("About");
    menuItem.setMnemonic(KeyEvent.VK_A);
    menuItem.addActionListener(this);
    menu.add(menuItem);
  
    menuBar = new JMenuBar();
    menuBar.add(menu);
    setJMenuBar(menuBar);
    
    panel = (JPanel)getContentPane();
    
    panel.setLayout(null);
    
    labelSpacecraft.setSize(80, 20);
    labelSpacecraft.setLocation(10, 15);
    panel.add(labelSpacecraft);
    
    comboSpacecraft.addActionListener(this);
    comboSpacecraft.setSize(100, 20);
    comboSpacecraft.setLocation(80, 15);
    panel.add(comboSpacecraft);
    
    labelStartFrom.setSize(60, 20);
    labelStartFrom.setLocation(200, 15);
    panel.add(labelStartFrom);
    
    comboStartFrom = new JComboBox(roundDistances);
    comboStartFrom.addActionListener(this);
    comboStartFrom.setSelectedItem("" + pioneer.startDistanceAU);
    comboStartFrom.setSize(60, 20);
    comboStartFrom.setLocation(265, 15);
    panel.add(comboStartFrom);
    
    labelEndAt.setSize(60, 20);
    labelEndAt.setLocation(340, 15);
    panel.add(labelEndAt);
    
    comboEndAt = new JComboBox(roundDistances);
    comboEndAt.addActionListener(this);
    comboEndAt.setSelectedItem("" + pioneer.endDistanceAU);
    comboEndAt.setSize(60, 20);
    comboEndAt.setLocation(385, 15);
    panel.add(comboEndAt);
    
    labelAU2.setSize(60, 20);
    labelAU2.setLocation(455, 15);
    panel.add(labelAU2);
    
    textArea.setFont(new Font("Courier New", Font.PLAIN, 12));
    //textArea.setBackground(Color.BLACK);
    //textArea.setForeground(Color.ORANGE);
    scrollableText.setSize(180, 180);
    scrollableText.setLocation(10, 90);
    panel.add(scrollableText);
    
    labelDistance.setSize(80, 20);
    labelDistance.setLocation(12, 50);
    panel.add(labelDistance);
    
    labelAU1.setSize(60, 20);
    labelAU1.setLocation(12, 70);
    panel.add(labelAU1);
    
    labelAcc.setSize(120, 20);
    labelAcc.setLocation(100, 50);
    panel.add(labelAcc);
    
    labelAccUnit1.setSize(120, 20);
    labelAccUnit1.setLocation(100, 70);
    panel.add(labelAccUnit1);
    
    labelDrift.setSize(80, 20);
    labelDrift.setLocation(210, 160);
    panel.add(labelDrift);
    
    textDrift.setEditable(false);
    textDrift.setSize(70, 20);
    textDrift.setLocation(245, 160);
    panel.add(textDrift);

    labelDriftUnit.setSize(40, 20);
    labelDriftUnit.setLocation(320, 160);
    panel.add(labelDriftUnit);
    
    labelDriftSpeed.setSize(80, 20);
    labelDriftSpeed.setLocation(210, 190);
    panel.add(labelDriftSpeed);

    textDriftSpeed.setEditable(false);
    textDriftSpeed.setSize(40, 20);
    textDriftSpeed.setLocation(280, 190);
    panel.add(textDriftSpeed);

    labelSpeedUnit.setSize(50, 20);
    labelSpeedUnit.setLocation(325, 190);
    panel.add(labelSpeedUnit);
    
    labelTime.setSize(80, 20);
    labelTime.setLocation(210, 220);
    panel.add(labelTime);

    textTime.setEditable(false);
    textTime.setSize(40, 20);
    textTime.setLocation(245, 220);
    panel.add(textTime);
    
    labelYear.setSize(60, 20);
    labelYear.setLocation(290, 220);
    panel.add(labelYear);
    
    labelEquivAcc.setSize(160, 20);
    labelEquivAcc.setLocation(210, 250);
    panel.add(labelEquivAcc);
    
    textEquivAcc.setEditable(false);
    textEquivAcc.setSize(40, 20);
    textEquivAcc.setLocation(365, 250);
    panel.add(textEquivAcc);
    
    labelAccUnit2.setSize(120, 20);
    labelAccUnit2.setLocation(410, 250);
    panel.add(labelAccUnit2);
    
    JEditorPane ep = new JEditorPane("text/html", msg);
    ep.setEditable(false);
    
    ep.setBounds(new Rectangle(210, 50, 320, 100));
    panel.add(ep);
  }
  
  public void actionPerformed(ActionEvent e) {
    
    if (e.getSource() instanceof JComboBox) {
      String fileName = "pioneer_10.txt";
      String spacecraft = (String)comboSpacecraft.getSelectedItem();
      if (spacecraft.equals("Pioneer 10")) {
        fileName = "pioneer_10.txt";
      }
      else if (spacecraft.equals("Pioneer 11")) {
        fileName = "pioneer_11.txt";
      }
      
      String tmp = (String)comboStartFrom.getSelectedItem();
      if (tmp != null) {
      pioneer.startDistanceAU = Integer.parseInt(tmp);
      }
      
      tmp = (String)comboEndAt.getSelectedItem();
      if (tmp != null) {
        pioneer.endDistanceAU = Integer.parseInt(tmp);
      }
      
      pioneer.loadAndProcessCoordinates(fileName);
    }
    
    if (e.getActionCommand().equals("About")) {
      DlgAbout about = new DlgAbout();
      about.setVisible(true);
    }
  }
  
  public static void main(String[] args) {
    DlgMain dlg = new DlgMain();
    dlg.init();
    
    dlg.setVisible(true);
  }
}