package org.masstheory;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;

public class DlgAbout extends JDialog implements ActionListener {
  
  static final long serialVersionUID = 7184777166544501396L;
  
  JButton btnOK = new JButton("OK");
  
  public DlgAbout(Frame parent) {
    super(parent);
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    
    init();
  }
  
  public DlgAbout() {
    this(null);
  }
  
  public void init() {
    setTitle("About Explanation of The Pioneer Anomaly");
    setSize(480, 260);
    
    setLocationRelativeTo(null);
    setResizable(false);
    
    getContentPane().setLayout(null);
    
    String msg = "Author: Aleksandar Vukelja, aleksandar@masstheory.org, 2010.<br><br>" +
    		"This software (the code) is in public domain.<br>Theory and source code are available at " +
    		"<a href='http://www.masstheory.org'><b>http://www.masstheory.org</b></a><br><br>" +
    		"The Pioneer spacecraft coordinates datasets are property of NASA,<br>" +
    		"<a href='http://ssd.jpl.nasa.gov/horizons.cgi'>http://ssd.jpl.nasa.gov/horizons.cgi</a>";
    
    JEditorPane ep = new JEditorPane("text/html", msg);
    ep.setEditable(false);
    
    ep.setBounds(new Rectangle(10, 10, 460, 180));
    getContentPane().add(ep);
    
    btnOK.setBounds(new Rectangle(211, 190, 88, 24));
    btnOK.addActionListener(new btnOK_actionAdapter(this));
    getContentPane().add(btnOK);
  }
  
  public void btnOK_actionPerformed(ActionEvent e) {
    dispose();
  }
  
  public void actionPerformed(ActionEvent actionEvent) {
    dispose();
  }
  
  class btnOK_actionAdapter implements ActionListener {
    private DlgAbout adaptee;
    btnOK_actionAdapter(DlgAbout adaptee) {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
      adaptee.btnOK_actionPerformed(e);
    }
  }
}